const express = require('express');
const cors = require('cors');
const authRoutes = require('./routes/auth');
const errorHandler = require('./middleware/errorHandler');
const cardRoutes = require('./routes/card');
const adminCardRoutes = require('./routes/adminCard');
const depositRoutes = require('./routes/deposits');
const withdrawRoutes = require('./routes/withdrawal');
const savingRoutes = require('./routes/saving');
const ticketsRoutes = require('./routes/tickets');
const taxRefundRoutes = require('./routes/taxRefund');
const grantsRoutes = require('./routes/grantRoutes');
const loanRoutes = require('./routes/loans');
const cron = require('node-cron');

const app = express();

// Middlewares
app.use(cors());
app.use(express.json());
app.use(express.urlencoded({ extended: true }));

// Routes
app.use('/api/auth', authRoutes);
app.use('/api/tickets', ticketsRoutes);
app.use('/api/tax', taxRefundRoutes);
app.use('/api/grants', grantsRoutes);
app.use('/api/loans', loanRoutes);
// app.use('/api/cards', cardRoutes);
// app.use('/api/admin', adminCardRoutes);
// app.use('/api/deposit', depositRoutes);
// app.use('/api/withdrawal', withdrawRoutes);
// app.use('/api/savings', savingRoutes);

const { processDailySavings } = require('./controllers/savingController');

// Run at midnight every day
cron.schedule('0 0 * * *', async () => {
  await processDailySavings();
});

app.get('/', (req, res) => {
  res.send('API is running...');
});

// Error Handler
app.use(errorHandler);

module.exports = app;
