const mongoose = require('mongoose');

const connectDB = async () => {
  try {
    await mongoose.connect(process.env.MONGO_URI);
    console.log('✅ MongoDB connected');
  } catch (err) {
    console.error('❌ MongoDB connection error:', err);
    process.exit(1);
  }
};

module.exports = connectDB;
// This code connects to a MongoDB database using Mongoose. 
// It exports a function `connectDB` that attempts to connect to the database 
// using the URI stored in the environment variable `MONGO_URI`. If the connection is successful, 
// it logs a success message; if it fails, it logs an error and exits the process. 
// This setup is typically used in a Node.js application to ensure that the database connection
//  is established before starting the server.