const Withdrawal = require('../models/Withdrawal');
const User = require('../models/Users');
const sendEmail = require('../utils/sendEmail');

exports.getAllWithdrawals = async (req, res) => {
  try {
    const withdrawals = await Withdrawal.find().populate('userId', 'name email').sort({ createdAt: -1 });
    res.json(withdrawals);
  } catch (err) {
    res.status(500).json({ message: 'Server error' });
  }
};

exports.approveWithdrawal = async (req, res) => {
  try {
    const withdrawal = await Withdrawal.findById(req.params.id).populate('userId');
    if (!withdrawal) return res.status(404).json({ message: 'Withdrawal not found' });

    withdrawal.status = 'approved';
    await withdrawal.save();

    await sendEmail(
      withdrawal.userId.email,
      'Withdrawal Approved',
      `Your withdrawal of $${withdrawal.amount} has been approved.`,
      `<p>Your withdrawal request has been processed and approved. Funds will arrive shortly.</p>`
    );

    res.json({ message: 'Withdrawal approved and user notified.' });
  } catch (err) {
    res.status(500).json({ message: 'Server error' });
  }
};

exports.declineWithdrawal = async (req, res) => {
  try {
    const withdrawal = await Withdrawal.findById(req.params.id).populate('userId');
    if (!withdrawal) return res.status(404).json({ message: 'Withdrawal not found' });

    withdrawal.status = 'declined';
    await withdrawal.save();

    await sendEmail(
      withdrawal.userId.email,
      'Withdrawal Declined',
      `Your withdrawal of $${withdrawal.amount} has been declined.`,
      `<p>Please contact support if you believe this is an error.</p>`
    );

    res.json({ message: 'Withdrawal declined and user notified.' });
  } catch (err) {
    res.status(500).json({ message: 'Server error' });
  }
};
