const Notification = require("../models/Notification");

// Create a notification
exports.createNotification = async (req, res) => {
  const { userId, title, message, icon } = req.body;

  try {
    const notification = new Notification({ userId, title, message, icon });
    await notification.save();

    res.status(201).json({ message: "Notification created", notification });
  } catch (error) {
    res.status(500).json({ message: "Server error", error });
  }
};

// Get all notifications for a user
exports.getUserNotifications = async (req, res) => {
  try {
    const notifications = await Notification.find({ userId: req.user.id }).sort({ createdAt: -1 });
    res.json({ notifications });
  } catch (error) {
    res.status(500).json({ message: "Server error", error });
  }
};

// Mark a notification as read
exports.markAsRead = async (req, res) => {
  try {
    const notification = await Notification.findByIdAndUpdate(
      req.params.id,
      { read: true },
      { new: true }
    );
    if (!notification) {
      return res.status(404).json({ message: "Notification not found" });
    }
    res.json({ message: "Marked as read", notification });
  } catch (error) {
    res.status(500).json({ message: "Server error", error });
  }
};


exports.getSingleNotification = async (req, res) => {
  try {
    const notification = await Notification.findById(req.params.id);
    if (!notification) {
      return res.status(404).json({ message: "Notification not found" });
    }
    res.json({ notification });
  } catch (error) {
    res.status(500).json({ message: "Server error", error });
  }
}