// controllers/ticketController.js
const Ticket = require('../models/Tickets');

exports.createTicket = async (req, res) => {
  try {
    const { title, priority, message } = req.body;

    // Validation
    if (!title || !message) {
      return res.status(400).json({ message: "Please fill in all required fields" });
    }

    const ticket = await Ticket.create({
      user: req.user.id,
      title,
      priority,
      message
    });

    res.status(201).json({
      success: true,
      data: ticket,
      message: "Ticket submitted successfully"
    });
  } catch (error) {
    console.error("Ticket Error:", error);
    res.status(500).json({ message: "Server error, could not submit ticket" });
  }
};