const Withdrawal = require('../models/Withdrawal');
const sendNotification = require('../utils/sendNotification');

exports.initiateWithdrawal = async (req, res) => {
  const {
    amount,
    withdrawalType, // new field
    // bank
    address, accountNumber, accountType, bankName, routingNumber, accountHolder, email,
    // crypto
    walletAddress, network, coin
  } = req.body;

  if (!amount || !withdrawalType) {
    return res.status(400).json({ message: 'Amount and withdrawal type are required.' });
  }

  try {
    const payload = {
      userId: req.user.id,
      amount,
      withdrawalType,
    };

    if (withdrawalType === 'bank') {
      if (!address || !accountNumber || !accountType || !bankName || !routingNumber || !accountHolder || !email) {
        return res.status(400).json({ message: 'All bank withdrawal fields are required.' });
      }

      Object.assign(payload, {
        address,
        accountNumber,
        accountType,
        bankName,
        routingNumber,
        accountHolder,
        email,
      });
    } else if (withdrawalType === 'crypto') {
      if (!walletAddress || !network || !coin) {
        return res.status(400).json({ message: 'All crypto withdrawal fields are required.' });
      }

      Object.assign(payload, {
        walletAddress,
        network,
        coin,
      });
    } else {
      return res.status(400).json({ message: 'Invalid withdrawal type.' });
    }

    const withdrawal = new Withdrawal(payload);
    await withdrawal.save();

    await sendNotification({
      userId: req.user.id,
      title: "Withdrawal Request Sent",
      message: `Your ${withdrawalType} withdrawal of $${amount} is being processed.`,
      icon: "arrow-up",
    });

    res.status(201).json({ message: 'Withdrawal request submitted.', withdrawal });
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: 'Server error' });
  }
};


exports.getMyWithdrawals = async (req, res) => {
  try {
    const withdrawals = await Withdrawal.find({ userId: req.user.id }).sort({ createdAt: -1 });
    res.json(withdrawals);
  } catch (err) {
    res.status(500).json({ message: 'Server error' });
  }
};