const mongoose = require('mongoose');

const depositSchema = new mongoose.Schema({
  userId: { type: mongoose.Schema.Types.ObjectId, ref: 'User' },
  amount: Number,
  depositType: { type: String, enum: ['crypto', 'paypal', 'cash'], required: true },
  cryptoMethod: { type: String, enum: ['BTC', 'ETH', 'USDT'], default: null },
  status: { type: String, enum: ['pending', 'awaiting-payment', 'submitted', 'approved', 'declined'], default: 'awaiting-payment' },
  adminNote: String,
  paymentDetails: String,
  createdAt: { type: Date, default: Date.now }
});

module.exports = mongoose.model('Deposit', depositSchema);
