const mongoose = require('mongoose');

const userSchema = new mongoose.Schema({
  // --- Step 1: Personal Information ---
  firstName: { 
    type: String, 
    required: [true, 'First Name is required'], 
    trim: true 
  },
  lastName: { 
    type: String, 
    required: [true, 'Last Name is required'], 
    trim: true 
  },
  middleName: { 
    type: String, 
    trim: true,
    default: null 
  },
  username: { 
    type: String, 
    required: [true, 'Username is required'], 
    unique: true, 
    trim: true 
  },

  // --- Step 2: Contact Information ---
  email: { 
    type: String, 
    required: [true, 'Email is required'], 
    unique: true, 
    lowercase: true, 
    trim: true 
  },
  phoneNumber: { 
    type: String, 
    required: [true, 'Phone Number is required'],
    trim: true
  },
  country: { 
    type: String, 
    required: [true, 'Country is required'] 
  },

  // --- Step 3: Account Setup ---
  currency: { 
    type: String, 
    required: [true, 'Currency is required'] 
  },
  accountType: { 
    type: String, 
    // You can add more types to this enum based on your dropdown options
    enum: ['Checking Account', 'Savings Account', 'Fixed Deposit Account', 'Current Account', 'Business Account', 'Investment Account'], 
    required: [true, 'Account Type is required'] 
  },
  pin: { 
    type: String, 
    required: [true, 'Transaction PIN is required'],
    minlength: 4, 
    maxlength: 4 
  },

  // --- Step 4: Security Setup ---
  password: { 
    type: String, 
    required: [true, 'Password is required'] 
  },
  termsAgreed: {
    type: Boolean,
    required: [true, 'You must agree to the Terms of Service'],
    default: false
  },

  // --- System / Backend Fields (Not in UI) ---
  accountNumber: { 
    type: String, 
    unique: true, 
    default: null 
  }, // Likely generated by backend
  balance: { 
    type: Number, 
    default: 0 
  },
  btcBalance: { 
    type: Number, 
    default: 0 
  },
  role: { 
    type: String, 
    enum: ['user', 'admin'], 
    default: 'user' 
  },
  isActive: { 
    type: Boolean, 
    default: true 
  },
  emailVerified: { 
    type: Boolean, 
    default: false 
  },
  verificationCode: String,
  verificationCodeExpires: Date,
  lastLogin: { 
    type: Date, 
    default: null 
  },
  profilePicture: { 
    type: String, 
    default: null 
  },
  twoStepEnabled: { 
    type: Boolean, 
    default: false 
  },
}, { 
  timestamps: true // Automatically creates createdAt and updatedAt
});

module.exports = mongoose.model('User', userSchema);