const express = require('express');
const router = express.Router();
const authMiddleware = require('../middleware/authMiddleware');
const isAdmin = require('../middleware/isAdmin');
const adminCardController = require('../controllers/adminCardController');

const adminDepositController = require('../controllers/depositController');

router.get('/cards', authMiddleware, isAdmin, adminCardController.getAllCardRequests);
router.put('/approve-card/:id', authMiddleware, isAdmin, adminCardController.approveCard);
router.put('/decline-card/:id', authMiddleware, isAdmin, adminCardController.declineCard);
router.get('/card/:id', authMiddleware, isAdmin, adminCardController.getSingleCardRequest);


router.get('/', authMiddleware, isAdmin, adminDepositController.getAllDeposits);
router.put('/details/:id', authMiddleware, isAdmin, adminDepositController.attachPaymentDetails);
router.put('/approve/:id', authMiddleware, isAdmin, adminDepositController.approveDeposit);
router.put('/decline/:id', authMiddleware, isAdmin, adminDepositController.declineDeposit);

module.exports = router;
