const express = require('express');
const router = express.Router();
const authController = require('../controllers/authController');
const authMiddleware = require('../middleware/authMiddleware');
const supportController = require("../controllers/authController");
const notificationController = require("../controllers/notificationController");
const upload = require('../middleware/upload');
const isAdmin = require('../middleware/isAdmin');

router.post('/register', authController.register);
router.post('/login', authController.login);
router.get('/me', authMiddleware, authController.getMe);
router.post('/update-pin', authMiddleware, authController.updatePin);
router.post('/enable-two-step', authMiddleware, authController.enableTwoStep);
router.post('/change-password', authMiddleware, authController.changePassword);
// router.post('/complete-profile', authMiddleware, authController.completeProfile);
// router.post('/verify-email-code', authMiddleware, authController.verifyEmailCode);
// router.post('/set-pin', authMiddleware, authController.setPin);
// router.get('/history', authMiddleware, authController.getUserTransactions);
router.post('/upload-picture', authMiddleware, upload.single('image'), authController.uploadProfilePicture);


// User routes
// router.post("/send", authMiddleware, authController.sendMessage);
// router.get("/my-messages", authMiddleware, authController.getMyMessages);

// router.post("/noftify", authMiddleware, notificationController.createNotification);
// router.get("/noftify", authMiddleware, notificationController.getUserNotifications);
// router.get("/noftify/:id", authMiddleware, notificationController.getSingleNotification);
// router.put("/noftify/:id/read", authMiddleware, notificationController.markAsRead);

// Admin routes
// router.get("/users", isAdmin, authController.getAllUsers);
// router.get("/profile/:id", isAdmin, authController.getUserById);
// router.get("/withdrawals", isAdmin, authController.getAllWithdrawals);
// router.get("/withdrawals/:id", isAdmin, authController.getSingleWithdrawal);
// router.put("/withdrawals/:id", isAdmin, authController.approveOrRejectWithdrawal);

// router.get("/deposits", isAdmin, authController.getAllDeposits);
// router.get("/deposits/:id", isAdmin, authController.getSingleDeposit);
// router.put("/deposits/:id", isAdmin, authController.approveOrRejectDeposit);
// router.get("/dashboard-stats", isAdmin, authController.getDashboardStats);

module.exports = router;