// routes/withdrawal.js
const express = require('express');
const router = express.Router();
const authMiddleware = require('../middleware/authMiddleware');
const isAdmin = require('../middleware/isAdmin');
const withdrawalController = require('../controllers/withdrawalController');
const adminWithdrawalController = require('../controllers/adminWithdrawalController');

// User Routes
router.post('/initiate', authMiddleware, withdrawalController.initiateWithdrawal);
router.get('/my', authMiddleware, withdrawalController.getMyWithdrawals);

// Admin Routes
router.get('/', authMiddleware, isAdmin, adminWithdrawalController.getAllWithdrawals);
router.put('/approve/:id', authMiddleware, isAdmin, adminWithdrawalController.approveWithdrawal);
router.put('/decline/:id', authMiddleware, isAdmin, adminWithdrawalController.declineWithdrawal);

module.exports = router;
