const Notification = require('../models/Notification');

const sendNotification = async ({ userId, title, message, icon = "info" }) => {
  try {
    const newNotification = new Notification({
      userId,
      title,
      message,
      icon,
    });
    await newNotification.save();
  } catch (err) {
    console.error("Failed to send notification:", err.message);
  }
};

module.exports = sendNotification;
